#include "starship.h"
#include "msxvideo.h"
#include <stdio.h>
#include <stdlib.h>

static const int xdirections[]={ 0,  0,  1, 1, 1, 0, -1, -1, -1};
static const int ydirections[]={ 0, -1, -1, 0, 1, 1,  1,  0, -1};

void starship_mem_alloc(pstarship s){
  s->b=(pbullet) malloc(STARSHIP_MAX_BULLETS*sizeof(bullet));
}

// before invoking this method, invoke starship_mem_alloc
void starship_setup(
  pstarship s,
  int x, int y, 
  int xmin, int xmax, int ymin, int ymax,
  int life, int ship_sprite_offset, int bullet_sprite_offset, int big, int spd
){
  s->x=(x-((big)?16:8))<<STARSHIP_SPACE_FACTOR; s->y=(y-((big)?16:8))<<STARSHIP_SPACE_FACTOR;
  s->vx=s->vy=0;
  s->xmin=xmin<<STARSHIP_SPACE_FACTOR; s->xmax=(xmax-((big)?32:16))<<STARSHIP_SPACE_FACTOR;
  s->ymin=ymin<<STARSHIP_SPACE_FACTOR; s->ymax=(ymax-((big)?32:16))<<STARSHIP_SPACE_FACTOR;
  s->life=3+2*life;
  s->bsize=0;
  s->ship_sprite_offset=ship_sprite_offset;
  s->bullet_sprite_offset=bullet_sprite_offset;
  s->big=big;
  s->spd=spd+1;
}

#define spd_saturate(x,xmin,xmax) ( ((x)>(xmin))? ( ((x)<(xmax))?(x):(xmax) ) :(xmin) )

void starship_update(pstarship s, char dir){
  int i,j,sz;
  s->vx= s->vx + xdirections[dir]*s->spd;
  s->vy= s->vy + ydirections[dir]*s->spd;
  s->vx=spd_saturate(s->vx,-((s->spd*2)<<STARSHIP_SPACE_FACTOR),((s->spd*2)<<STARSHIP_SPACE_FACTOR));
  s->vy=spd_saturate(s->vy,-((s->spd)<<STARSHIP_SPACE_FACTOR),((s->spd)<<STARSHIP_SPACE_FACTOR));
  s->x+=s->vx; s->y+=s->vy;
  if (s->x<s->xmin || s->x>s->xmax){ s->x-=s->vx; s->vx=-s->vx; }
  if (s->y<s->ymin || s->y>s->ymax){ s->y-=s->vy; s->vy=-s->vy; }
  
  sz=i=s->bsize;
  for (j=0;j<sz;j++){
    i--;
    s->b[i].y+=s->b[i].vy;
    if (s->b[i].y < (-32)<<STARSHIP_SPACE_FACTOR || s->b[i].y >((191-16)<<STARSHIP_SPACE_FACTOR)){
      starship_kill_bullet(s, i);
    }
  }
  for (j=0;j<(STARSHIP_MAX_BULLETS-sz);j++){
    for (i=0;i<100;i++){ }
  }
}

void starship_plot(pstarship s, char color1, char color2, char color3){
  int x,y,i,ship_sprite_offset,bullet_sprite_offset;
  
  ship_sprite_offset=s->ship_sprite_offset;
  bullet_sprite_offset=s->bullet_sprite_offset;
  x=s->x>>STARSHIP_SPACE_FACTOR; y=s->y>>STARSHIP_SPACE_FACTOR;
  screen1_sprite_put(ship_sprite_offset++, x, y, color1);
  screen1_sprite_put(ship_sprite_offset++, x, y, color2);
  
  for (i=0;i<s->bsize;i++){
    screen1_sprite_put(
      bullet_sprite_offset++,
      s->b[i].x>>STARSHIP_SPACE_FACTOR,
      s->b[i].y>>STARSHIP_SPACE_FACTOR, color3
    );
  }
}

void starship_shoot(pstarship s, int vy){
  pbullet pb;
  if (s->bsize<STARSHIP_MAX_BULLETS){
    pb=&(s->b[s->bsize]);
    pb->x=s->x;
    pb->y=s->y;
    pb->vy=vy<<(STARSHIP_SPACE_FACTOR-1);
    s->bsize++;
  }
}

void starship_kill_bullet(pstarship s, int i){
  pbullet pb;
  pbullet pb2;
  if (s->bsize>0){
    if (i<s->bsize-1){
      pb=&(s->b[i]);
      pb2=&(s->b[s->bsize-1]);

      pb->x=pb2->x;
      pb->y=pb2->y;
      pb->vy=pb2->vy;
      pb->color=pb2->color;
    }
    screen1_sprite_put((s->bullet_sprite_offset+s->bsize-1)&0xff,0,209,7);
    s->bsize--;
  }  
}

void starship_kill_all_bullets(pstarship ship){
  int i,s;
  s=ship->bsize;
  for(i=s-1; i>=0; i--){
	  starship_kill_bullet(ship, i);
  }
}

char starship_detect_explosion(pstarship shooter, pstarship target){
  int i,j,s,dx,dy;  
  char ret=0;
  s=i=shooter->bsize;
  for (j=0;j<s;j++){
    i--;
    dx=shooter->b[i].x-target->x;
    dy=shooter->b[i].y-target->y;
    if (
      ((dx<0)?-dx:dx) < ((target->big)?24:12)<<STARSHIP_SPACE_FACTOR &&
      ((dy<0)?-dy:dy) < ((target->big)?24:12)<<STARSHIP_SPACE_FACTOR
    ){
      starship_kill_bullet(shooter, i); ret++;
    }
  }
  return ret;
}

